% ALPHA ENGINE DEFINITION
% Generated 03-Aug-2023 08:05:26

% SUGGESTED CITATION:
% 2018 Mazda 2.5L Skyactiv-G Engine Tier 2 Fuel - ALPHA Map Package. Version 2023-08. Ann Arbor MI: US EPA National Vehicle and Fuel Emissions Laboratory, National Center for Advanced Technology, 2023.


% Constructor
engine = class_REVS_engine();
engine.name =  '2018 Mazda 2.5L Skyactiv-G Engine Tier 2 Fuel'; 
engine.source_filename = mfilename;
engine.matrix_vintage = enum_matrix_vintage.present;

% Physical Description
engine.displacement_L =  2.488; 
engine.num_cylinders =  4; 
engine.combustion_type = enum_engine_combustion_type.spark_ignition;
engine.compression_ratio =  13; 
engine.stroke_mm =  100; 

% Maximum Torque Curve
engine.full_throttle_speed_radps = [	     0.0000000000000000	;     104.51031560942045	;     135.82152239019871	;     156.66075365901102	;     209.12535097396056	;     261.38050877867079	;     339.81560536329596	;     418.87902047863906	;     628.31853071795865	;     659.73445725385659	;     691.15038378975453		]; 
engine.full_throttle_torque_Nm = [	     0.0000000000000000	;     153.19999999999999	;     191.19999999999999	;     202.19999999999999	;     219.40000000000001	;     228.90000000000001	;     237.30000000000001	;     252.18214799999998	;     221.93501302700693	;     190.23001116600594	;     0.0000000000000000		]; 
engine.naturally_aspirated_speed_radps = [	     0.0000000000000000	;     133.71821496822091	;     209.02221788179733	;     235.18699521568476	;     287.44263783407621	;     313.62302799224585	;     365.88591564956994	;     418.25070194792107	;     470.55821963019116	;     691.15038378975453		]; 
engine.naturally_aspirated_torque_Nm = [	     82.850579933362027	;     159.96296258998501	;     196.08578241028394	;     204.66986186102093	;     207.07930195069832	;     215.73063486969261	;     245.31305525048225	;     271.77371631351838	;     319.45221051592648	;     558.46529216359431		]; 

% Minimum Torque Curve
engine.closed_throttle_speed_radps = [	     0.0000000000000000	;     114.98229112138642	;     313.53094682826134	;     365.89082438809123	;     522.86573731246119	;     691.15038378975453		]; 
engine.closed_throttle_torque_Nm = [	    -20.139152759948644	;    -26.199999999999999	;    -32.299999999999997	;    -36.899999999999999	;    -47.700000000000003	;    -56.570474967907579		]; 

% Fuel Map
engine.fuel_map_speed_radps = [	     0.0000000000000000	;     35.866516128483468	;     71.733032256966936	;     104.51031560942046	;     114.98229112138642	;     133.71821496822091	;     156.76547341413067	;     182.92865703322650	;     209.02221788179733	;     235.18699521568476	;     261.36741880928082	;     287.44263783407621	;     313.62302799224585	;     339.80291205964500	;     365.88591564956994	;     418.25070194792107	;     470.55821963019116	;     522.86573731246119	;     607.00806055110786	;     691.15038378975453		]; 
engine.fuel_map_torque_Nm = [	    -59.398998716302962	;    -47.700000000000003	;    -30.734285714285711	;    -14.300000000000001	;    -1.6959459459459461	;     14.002631578947369	;     23.938461538461539	;     36.924193548387095	;     48.816666666666663	;     54.181818181818187	;     66.461904761904748	;     77.428124999999994	;     91.761666666666656	;     99.900000000000006	;     109.20294117647059	;     119.00772058823529	;     128.81250000000000	;     139.55714285714288	;     151.01562500000003	;     162.85000000000002	;     170.19999999999999	;     176.42500000000001	;     189.71875000000000	;     207.02812499999999	;     217.81147629310345	;     228.59482758620689	;     243.59999999999999	;     254.19562769999999	;     264.79125540000001		]; 
engine.fuel_map_gps = [
 -0.045942410102491199	  -0.15498479774432228	  -0.26348316953999174	  -0.31088716026525909	  -0.32522787603187919	  -0.35037566991660574	  -0.37975768489809114	  -0.40999362786306132	  -0.43563475399598756	  -0.45574321618870534	  -0.46934254929519936	  -0.47605594215572111	  -0.47622666864693275	  -0.47053338429877495	  -0.45992456748326366	  -0.42023355718668903	  -0.35935695013916036	  -0.29267611127704923	  -0.20564672712780072	  -0.13048075533946774	;
 -0.027948050920673474	  -0.11335816068581508	  -0.16822255764088684	  -0.19806109298741423	  -0.20666678420556361	  -0.22124934342351271	  -0.23713539815120180	  -0.25223557739876601	  -0.26421703015341957	  -0.27288475418876962	  -0.27719873066692391	  -0.27538596612667277	  -0.26553431265168115	  -0.24704218786535087	  -0.22256281781984433	  -0.17004542871984493	 -0.090054660144402249	 0.0023013619052001137	   0.12898945105134912	   0.25445271424913762	;
-0.0038575452039407380	 -0.018794964440370088	 -0.027127322227854467	 -0.035432380045349370	 -0.036619907135247556	 -0.036542703050569267	 -0.032231474916341318	 -0.024351098178878122	 -0.013207757425353945	-0.00074710660199812148	 0.0099197475065792851	  0.021341087523365606	  0.042068010740682629	  0.076926393208788205	   0.11956094403407443	   0.19598843069667268	   0.29868868795232512	   0.41702167035235849	   0.61513153270992449	   0.81412074543463553	;
  0.034772839600796426	  0.071409778836830237	   0.10835268012124855	   0.13427755367315022	   0.13787540397049897	   0.14378032840758453	   0.15607502159094819	   0.18153723213802225	   0.21944310464284081	   0.26556697693309556	   0.31241181608168000	   0.35143462231518618	   0.37905209662911071	   0.40838981870325430	   0.44393718794478981	   0.54368199129983552	   0.67758722917308922	   0.83022765137883636	    1.0959617383989548	    1.3611927107646640	;
  0.051278674314927310	   0.10425362633695125	   0.15250181772447519	   0.18529819140330323	   0.19842184974245350	   0.22417454126663125	   0.25932318228164525	   0.30480853229108151	   0.35506076525561869	   0.41204605648058462	   0.47135399122894017	   0.52530353952339914	   0.57351975920901599	   0.62228560801423993	   0.67520084966468341	   0.80687100530558453	   0.97399991074721748	    1.1601250597362944	    1.4741027682585213	    1.7852136364036093	;
  0.044740487385032279	   0.11479757351590195	   0.18484452917005628	   0.25326940396999431	   0.27728817828784397	   0.32150414964745655	   0.37599284678271189	   0.43735896342138009	   0.49735426980894953	   0.55979103187003065	   0.62403077487712366	   0.69303585463451911	   0.77119678607964726	   0.85428856641717932	   0.94256264857282845	    1.1305115250572466	    1.3508527040386511	    1.5868501936942598	    1.9557165371158765	    2.3201093162822697	;
  0.035279552188056409	   0.12283741562735698	   0.21264698581971270	   0.30051363936365805	   0.32968899065396845	   0.38274634940743735	   0.44892899138450065	   0.52291979219986884	   0.59735963036010120	   0.67133625814215303	   0.74647674044280676	   0.82719167736046084	   0.91551793625589739	    1.0122826835706527	    1.1166592137386107	    1.3367063159952217	    1.5923669535306650	    1.8603610963235802	    2.2636254390569301	    2.6633577041327401	;
  0.023152016058908327	   0.13798981379597755	   0.25440095583929873	   0.36388507729423442	   0.39949016254066616	   0.46420803791768822	   0.54622812062226955	   0.63733590624031611	   0.72683576115369330	   0.81465401423917105	   0.90636277548081989	    1.0045584261556295	    1.1118847564047316	    1.2307346228278246	    1.3566555698814073	    1.6202367721344084	    1.9114104144616799	    2.2110131361709646	    2.6680459210199055	    3.1179013239667279	;
  0.015616398345129536	   0.15619006851604225	   0.29720421133151209	   0.42706518760409501	   0.46886568623125069	   0.54407362117013480	   0.63781888078476223	   0.74491623996711442	   0.85043591408514352	   0.95526844749569639	    1.0626261024125048	    1.1748881737072034	    1.2974805731561505	    1.4346248560939741	    1.5814595785946113	    1.8870653504735013	    2.2071552835767321	    2.5319630745307729	    3.0413488517720340	    3.5422581720761559	;
  0.012975439995273402	   0.16496358616031187	   0.31713414978270327	   0.45620205592959689	   0.50065185519357747	   0.58026852166302578	   0.67891158767889137	   0.79258298064976740	   0.90612359051827185	    1.0199627996837810	    1.1355451166179757	    1.2534857714972116	    1.3828063186877690	    1.5282317424356375	    1.6844134285726506	    2.0078176827782492	    2.3411510801042117	    2.6780294544992720	    3.2108843874691644	    3.7358921613029366	;
 0.0085239479973865055	   0.18584414370801400	   0.36329252632106795	   0.52394202499879705	   0.57418066051456118	   0.66386609704531141	   0.77499372377923514	   0.90387156958352421	    1.0358176505479262	    1.1694678916781056	    1.3031077632290127	    1.4366793474018331	    1.5837065943159800	    1.7481955308505159	    1.9222697990147359	    2.2844235894726905	    2.6489478305784213	    3.0156704229600635	    3.6021902749335726	    4.1849349413432178	;
 0.0059306165422782203	   0.20438010133684431	   0.40140362542491081	   0.57992668703580197	   0.63723802959849807	   0.74052045832778091	   0.86763799208688941	    1.0127189527218630	    1.1574617533885763	    1.3057215374738953	    1.4561177005348538	    1.6054011214285855	    1.7675935963052440	    1.9461960429480094	    2.1343429933070586	    2.5293835530633335	    2.9245887370813737	    3.3204637719316343	    3.9586126706277285	    4.5975437178719325	;
 0.0028853460388048517	   0.23126952508922793	   0.45751435758830561	   0.66039372175230449	   0.72447036594619429	   0.84093175107798401	   0.98713518145746026	    1.1515518196961121	    1.3156496825220765	    1.4820625604782207	    1.6539843428813041	    1.8265669673811298	    2.0089418970600974	    2.2059292113952611	    2.4135066177773790	    2.8511376868101332	    3.2862314311561622	    3.7247160111002442	    4.4377738597193188	    5.1586406046374726	;
 0.0021575247541851398	   0.24802627765661633	   0.49172181768229550	   0.70950457400462430	   0.77827869551797402	   0.90184714102367947	    1.0568373833596567	    1.2314232207256277	    1.4061017686287811	    1.5840661987972842	    1.7670042477785768	    1.9499042970877207	    2.1426525264582574	    2.3517816935271711	    2.5700540306068356	    3.0299148393071413	    3.4923454091576884	    3.9574363075894481	    4.7172218214951727	    5.4891834219952473	;
 0.0034594084329107396	   0.26850803755803881	   0.53229517927739856	   0.76996914612313738	   0.84489073126947001	   0.97768090467038049	    1.1415250225748843	    1.3252829120787293	    1.5108165961225897	    1.7016956545854380	    1.8957698952471398	    2.0925576492073201	    2.3000545067596212	    2.5193624543455497	    2.7486494965981350	    3.2366496219182697	    3.7292502761735449	    4.2258797403976995	    5.0423742764130042	    5.8759904566966954	;
  0.011254649561998294	   0.29336534431863259	   0.57531611337443866	   0.83121699715945052	   0.91214718174416443	    1.0560032087543529	    1.2309802000187360	    1.4277326142985169	    1.6268534407380884	    1.8289792289638576	    2.0343655851869116	    2.2434116509400774	    2.4641772096780370	    2.6964040407622734	    2.9386531688910575	    3.4590770255516126	    3.9813381827316476	    4.5125887335604906	    5.3933684578220040	    6.2957489467489509	;
  0.031002124893228566	   0.32471353675156972	   0.61951358785027766	   0.89019966263489747	   0.97695547525556947	    1.1318882747970966	    1.3204893470849099	    1.5334608303428745	    1.7467683587886687	    1.9605022485327177	    2.1762452563946422	    2.3943376648705872	    2.6249026681397130	    2.8708886310306192	    3.1277650390410932	    3.6800730838637072	    4.2361585120686769	    4.8047970747673814	    5.7545019927501686	    6.7285938175612428	;
  0.073429365562470802	   0.37234235518008774	   0.67474550820190027	   0.95680869903950727	    1.0474333589637601	    1.2094815736481874	    1.4103338513696289	    1.6421552775875417	    1.8759066379881084	    2.1080667872652130	    2.3357945427637565	    2.5651783843956348	    2.8060975249623072	    3.0645777874066664	    3.3377967126200772	    3.9228207725098887	    4.5202685282082005	    5.1341912730450989	    6.1642455833472427	    7.2183922796623561	;
   0.15179778490915252	   0.44801097273800683	   0.74846113531949121	    1.0304472125071098	    1.1214050413334438	    1.2861504488197602	    1.4976263329761659	    1.7497232916524819	    2.0091305709189209	    2.2647213507355390	    2.5094739870059750	    2.7513774280171983	    3.0077025922527034	    3.2810227366894242	    3.5707056648424018	    4.1919293238920918	    4.8338655704979780	    5.5017575095890452	    6.6208737162240299	    7.7584866453718453	;
   0.27336461178033022	   0.56482421104288238	   0.85835311910504908	    1.1344904180307076	    1.2251398469069743	    1.3900915145338084	    1.6028494034321572	    1.8632230290025593	    2.1489872836896429	    2.4396884364996527	    2.6950568954311387	    2.9470597600685640	    3.2153962895506760	    3.5034401847731282	    3.8088737040006397	    4.4727741919598492	    5.1769431080228197	    5.9076700023640170	    7.1166461181947849	    8.3333464398131571	;
   0.36421388857517117	   0.65790281509847559	   0.95208272443713826	    1.2261968342586058	    1.3161921663089349	    1.4799328451660074	    1.6919123516241081	    1.9527295486009910	    2.2324602041404744	    2.5219497974131069	    2.7982059427263213	    3.0671645490208674	    3.3452593325995932	    3.6411289285765140	    3.9611729275432404	    4.6567014729202238	    5.4034774553304450	    6.1738760811086486	    7.4347851333530119	    8.6957525830317017	;
   0.44680595891891423	   0.74554956196722744	    1.0438367022538904	    1.3187747338605007	    1.4081390465893646	    1.5702405011460900	    1.7814478727453129	    2.0409734494570340	    2.3126314048328265	    2.6016214883025777	    2.8889865011064160	    3.1677275471841928	    3.4542689024505759	    3.7617375981639789	    4.0937118477922914	    4.8186310789278526	    5.6024569566706894	    6.4057854452268108	    7.7083561513435788	    9.0044444214041786	;
   0.64455621751335357	   0.96826009028089410	    1.2915373843463296	    1.5867664585152705	    1.6812546208179848	    1.8506069136285153	    2.0610437339186927	    2.3082960006408024	    2.5652268589825287	    2.8354918913707476	    3.1118700565817576	    3.3870508992724968	    3.6824472300648967	    4.0098135200558769	    4.3710134236133182	    5.1973782356483822	    6.0621071873980723	    6.9295569302109188	    8.3092383847007891	    9.6694606284150488	;
   0.94829459493019463	    1.3308075366854732	    1.7143951612958532	    2.0658247395093015	    2.1776564441072845	    2.3767156551152433	    2.6127748734194407	    2.8456118259453858	    3.0306367357840669	    3.2593635035754742	    3.4933745432841361	    3.7545096168398309	    4.0633619821324061	    4.4234625602276214	    4.8311183384251803	    5.8310828583132377	    6.7679711479557909	    7.6897833059058680	    9.1296807393826001	    10.541532780066785	;
    1.1480764118487086	    1.5645790440472909	    1.9798767116246350	    2.3527680912156579	    2.4693440877143789	    2.6751311324154154	    2.9175340163528727	    3.1703030304643121	    3.4004180137502273	    3.6302350441446292	    3.8512333031520640	    4.0875233224879892	    4.3978984688657725	    4.7743740786116557	    5.2077409125827945	    6.2471898304057500	    7.2408632030420410	    8.1888322661722075	    9.6486831434082152	    11.081743629345878	;
    1.3477302168785035	    1.7932732596972101	    2.2349822254965690	    2.6285177319969133	    2.7520031326350227	    2.9709811758196065	    3.2355549951666092	    3.5299416039545219	    3.8178321616712130	    4.0926041729775067	    4.3259883103667613	    4.5590621892423906	    4.8368141126008410	    5.2000265961231502	    5.6708955550215121	    6.7269112565879663	    7.7375925454105072	    8.6954702164923674	    10.168265505071302	    11.618958715061774	;
    1.6155891248064276	    2.0954432080006353	    2.5729614051054286	    3.0051406152912659	    3.1425578119748367	    3.3878662282598055	    3.6881699780956558	    4.0262609792848147	    4.3586792291048528	    4.6859149153855659	    5.0106068530217502	    5.3429038561164921	    5.6987586851822005	    6.0975566994655219	    6.5592913639151336	    7.5323623134399513	    8.4723894863799512	    9.4068187736300466	    10.887975153487165	    12.360330458677252	;
    1.7974275464861487	    2.3023095792268049	    2.8071526316549416	    3.2690939585532894	    3.4168981514366781	    3.6815530232137639	    4.0077409133385427	    4.3791233443687458	    4.7510578820245817	    5.1269143301949072	    5.5089223475018345	    5.8990553616755896	    6.3048913705220029	    6.7288522418588537	    7.1683017795992328	    8.0874461779644342	    8.9988208858962437	    9.9132908271574216	    11.394192604015533	    12.881058018049092	;
    1.9767410544372099	    2.5073871675511388	    3.0402497896683873	    3.5322400901533908	    3.6905231011674742	    3.9747485911981220	    4.3276722347947842	    4.7349356388830932	    5.1503123270936504	    5.5770619947084974	    6.0136582342112144	    6.4550751833874767	    6.9003419468682337	    7.3431419075988389	    7.7800033176485117	    8.6481802877233420	    9.5266692914754181	    10.420955100588982	    11.899785731935571	    13.400945819759192	]; 
engine.deac_fuel_map_gps = [
                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	   0.29016025458528805	   0.32131363744014696	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	   0.23176071604168152	   0.27325405358191918	   0.31875065061738872	   0.36768253144955237	   0.41681482737666070	   0.47578363272411306	   0.53018217676585710	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	   0.29964208123309510	   0.35127062823450250	   0.40254203839999603	   0.46536714977889798	   0.53105217386142833	   0.60634065866847942	   0.67138078643827070	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	   0.38804147709045000	   0.46140561634236643	   0.52734147847331225	   0.60824202914555447	   0.69142814092636218	   0.78613495270909040	   0.86892452426110023	   0.95148518190519948	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	   0.48768822173507431	   0.57404667058481529	   0.65422695368912975	   0.74482598785724896	   0.84226729786359023	   0.94993286095592544	    1.0506123018092164	    1.1507992493884682	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	   0.52842143225174310	   0.61749369655211106	   0.71470976790976437	   0.81170938193269604	   0.91554717958271237	    1.0270133876430609	    1.1338049528312164	    1.2421647439953896	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	   0.72017135760764051	   0.84806872885930162	   0.97141458566687511	    1.1108913975432859	    1.2201384554735870	    1.3294166874403903	    1.4598476612925837	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	   0.84992519566324354	   0.97337306322948558	    1.1032396082618496	    1.2690176704246696	    1.3873675250272617	    1.5290746869015996	    1.6895970097275643	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	    1.4820625604782207	    1.6539843428813041	    1.8170340464799322	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	]; 

% Fuel Properties
engine.fuel = class_REVS_fuel('FTAG 28636');

% Idle Speed
engine.idle_target_speed_radps = class_REVS_dynamic_lookup;
engine.idle_target_speed_radps.axis_1.signal =  'eng_runtime_sec'; 
engine.idle_target_speed_radps.axis_1.breakpoints = [	     0.0000000000000000	    10.000000000000000		]; 
engine.idle_target_speed_radps.table = [	     60.737457969402662	    60.737457969402662		]; 

% Calibration Adjustment Factors
engine.variant =  'basic engine'; 
